
<?php
 include('../db_connect.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$dioramas = $conn->query("SELECT id, name FROM diorama");
$filter_diorama = isset($_GET['filter_diorama']) ? $_GET['filter_diorama'] : 'all';
?>
<div class="col-lg-12">
    <div class="card card-outline card-success">
        <div class="card-header">
            <b>Assessment Questions</b>
            <div class="card-tools">
                <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Add Question</button>
            </div>
        </div>
        <div class="card-body">
            <!-- Filter Section -->
            <div class="row mb-3">
                <div class="col-md-6">
                    <form method="GET" id="filterForm" class="form-inline">
                        <!-- Keep the current page parameter -->
                        <input type="hidden" name="page" value="assessment">
                        <div class="form-group mr-2">
                            <label class="mr-2"><strong>Filter by Diorama:</strong></label>
                            <select class="form-control" name="filter_diorama" id="filter_diorama" onchange="document.getElementById('filterForm').submit()">
                                <option value="all" <?= $filter_diorama == 'all' ? 'selected' : '' ?>>All Dioramas</option>
                                <?php 
                                // Reset the dioramas result pointer
                                $dioramas->data_seek(0);
                                while($d = $dioramas->fetch_assoc()): 
                                ?>
                                <option value="<?= $d['id'] ?>" <?= $filter_diorama == $d['id'] ? 'selected' : '' ?>><?= $d['name'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </form>
                </div>
                <div class="col-md-6 text-right">
                    <button class="btn btn-sm btn-outline-secondary" id="clearFilter">Clear Filter</button>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="questionList">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Question</th>
                            <th>Choice A</th>
                            <th>Choice B</th>
                            <th>Choice C</th>
                            <th>Choice D</th>
                            <th>Diorama</th>
                            <th>Language</th>
                            <th>Correct Answer</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $i = 1;
                        // Modify the query for filtering
                        $where = "";
                        if($filter_diorama != 'all') {
                            $where = " WHERE diorama_id = '$filter_diorama'";
                        }
                        
                        $qry = $conn->query("SELECT a.*, d.name as diorama_name 
                                            FROM assessment_questions a 
                                            LEFT JOIN diorama d ON a.diorama_id = d.id
                                            $where
                                            ORDER BY a.id ASC");
                        
                        while($row = $qry->fetch_assoc()):
                        ?>
                        <tr>
                            <td><?php echo $i++ ?></td>
                            <td><?php echo $row['question'] ?></td>
                            <td><?php echo $row['a'] ?></td>
                            <td><?php echo $row['b'] ?></td>
                            <td><?php echo $row['c'] ?></td>
                            <td><?php echo $row['d'] ?></td>
                            <td><?php echo $row['diorama_name'] ?></td>
<td>
  <?php 
    echo $row['language'] == 'tagalog' ? 'Filipino' : ucfirst($row['language']); 
  ?>
</td>                            <td><?php echo strtoupper($row['correct_answer']) ?></td>
                            <td>
                                <button class="btn btn-sm btn-info editBtn" data-id="<?php echo $row['id'] ?>" data-question='<?php echo json_encode($row) ?>'><i class="fa fa-edit"></i></button>
                                <button class="btn btn-sm btn-danger deleteBtn" data-id="<?php echo $row['id'] ?>"><i class="fa fa-trash"></i></button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Add Question Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
  <div class="modal-dialog">
    <form id="addForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Add Question</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
             <div class="form-group">
            <label>Assessment for Diorama: </label>
            <select class="form-control" name="diorama_id" required>
              <option value="" disabled selected>Select Diorama</option>
              <?php 
              // Reset the dioramas result pointer
              $dioramas->data_seek(0);
              while ($d = $dioramas->fetch_assoc()): 
              ?>
                <option value="<?= $d['id'] ?>"><?= $d['name'] ?></option>
              <?php endwhile; ?>
            </select>
          </div>
          <div class="form-group">
            <label>Language</label>
            <select class="form-control" name="language" required>
              <option value="" disabled selected>Select Language</option>
              <option value="english">English</option>
              <option value="tagalog">Filipino</option>
            </select>
          </div>
          <div class="form-group">
            <label>Question</label>
            <textarea class="form-control" name="question" required></textarea>
          </div>
          <div class="form-group"><label>Choice A</label><input type="text" class="form-control" name="a" required></div>
          <div class="form-group"><label>Choice B</label><input type="text" class="form-control" name="b" required></div>
          <div class="form-group"><label>Choice C</label><input type="text" class="form-control" name="c" required></div>
          <div class="form-group"><label>Choice D</label><input type="text" class="form-control" name="d" required></div>

         

          <div class="form-group">
            <label>Correct Answer</label>
            <select class="form-control" name="correct_answer" required>
              <option value="" disabled selected>Select Correct Answer</option>
              <option value="a">A</option>
              <option value="b">B</option>
              <option value="c">C</option>
              <option value="d">D</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Save</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Edit Question Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
  <div class="modal-dialog">
    <?php
    $dioramas2 = $conn->query("SELECT id, name FROM diorama");
    ?>
    <form id="editForm">
      <input type="hidden" name="id">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Edit Question</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
             <div class="form-group">
            <label>Assessment for Diorama: </label>
            <select class="form-control" name="diorama_id" required id="edit_diorama">
              <option value="" disabled>Select Diorama</option>
              <?php while ($d = $dioramas2->fetch_assoc()): ?>
                <option value="<?= $d['id'] ?>"><?= $d['name'] ?></option>
              <?php endwhile; ?>
            </select>
          </div>
          <div class="form-group">
            <label>Language</label>
            <select class="form-control" name="language" id="edit_language" required>
              <option value="english">English</option>
              <option value="tagalog">Filipino</option>
            </select>
          </div>
          <div class="form-group"><label>Question</label><textarea class="form-control" name="question" required></textarea></div>
          <div class="form-group"><label>Choice A</label>
          <input type="text" class="form-control" name="a" required>
          <input type="hidden" class="form-control" name="prev_a"  >
        </div>
          <div class="form-group"><label>Choice B</label>
          <input type="text" class="form-control" name="b" required>
          <input type="hidden" class="form-control" name="prev_b" >
        </div>
          <div class="form-group"><label>Choice C</label>
          <input type="text" class="form-control" name="c" required>
          <input type="hidden" class="form-control" name="prev_c" required>
        </div>
          <div class="form-group"><label>Choice D</label>
          <input type="text" class="form-control" name="d" required>
          <input type="hidden" class="form-control" name="prev_d">
        </div>

         
          <div class="form-group">
            <label>Correct Answer</label>
            <select class="form-control" name="correct_answer" id="edit_correct" required>
              <option value="a">A</option>
              <option value="b">B</option>
              <option value="c">C</option>
              <option value="d">D</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </div>
    </form>
  </div>
</div>

<script>
$(document).ready(function () {
    $('#questionList').DataTable({
        "responsive": true,
        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
        "order": [[ 0, "asc" ]] // Sort by the first column (ID) in ascending order
    });

    // Clear filter button
    $('#clearFilter').click(function() {
        window.location.href = '?page=assessment';
    });

    // Add question
    $('#addForm').submit(function (e) {
        e.preventDefault();
        $.post('save_question.php', $(this).serialize(), function (resp) {
            if (resp == 1) {
                Swal.fire('Success', 'Question added!', 'success');
                // Preserve the current filter when reloading
                let currentUrl = window.location.href;
                setTimeout(() => window.location.href = currentUrl, 1000);
            }
        });
    });

    // Edit button click
    $('.editBtn').click(function () {
        let data = $(this).data('question');
        $('#editForm [name="id"]').val(data.id);
        $('#editForm [name="question"]').val(data.question);
        $('#editForm [name="a"]').val(data.a);
        $('#editForm [name="b"]').val(data.b);
        $('#editForm [name="c"]').val(data.c);
        $('#editForm [name="d"]').val(data.d);
        $('#editForm [name="prev_a"]').val(data.a);
        $('#editForm [name="prev_b"]').val(data.b);
        $('#editForm [name="prev_c"]').val(data.c);
        $('#editForm [name="prev_d"]').val(data.d);
        $('#editForm [name="diorama_id"]').val(data.diorama_id);
        $('#editForm [name="language"]').val(data.language);
        $('#editForm [name="correct_answer"]').val(data.correct_answer);

        $('#editModal').modal('show');
    });

    // Edit form submit
    $('#editForm').submit(function (e) {
        e.preventDefault();
        $.post('update_question.php', $(this).serialize(), function (resp) {
            if (resp == 1) {
                Swal.fire('Updated!', 'Question updated.', 'success');
                // Preserve the current filter when reloading
                let currentUrl = window.location.href;
                setTimeout(() => window.location.href = currentUrl, 1000);
            }
        });
    });

    // Delete question
    $('.deleteBtn').click(function () {
        let id = $(this).data('id');
        Swal.fire({
            title: 'Are you sure?',
            text: "You can't undo this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post('delete_question.php', { id: id }, function (resp) {
                    if (resp == 1) {
                        Swal.fire('Deleted!', 'Question has been removed.', 'success');
                        // Preserve the current filter when reloading
                        let currentUrl = window.location.href;
                        setTimeout(() => window.location.href = currentUrl, 1000);
                    }
                });
            }
        });
    });
});
</script>