<?php
 include('../db_connect.php');
require_once('phpqrcode/qrlib.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $description_english_minor = $_POST['description_english_minor'];
    $description_english_adult = $_POST['description_english_adult'];
    $description_tagalog_minor = $_POST['description_tagalog_minor'];
    $description_tagalog_adult = $_POST['description_tagalog_adult'];

    // Image Upload
    $imageName = $_FILES['picture']['name'];
    $imagePath = 'uploads/images/' . $imageName;
    move_uploaded_file($_FILES['picture']['tmp_name'], $imagePath);

    // Audio Uploads
    $tagalogMinor = $_FILES['tagalog_minor_audio']['name'];
    $tagalogAdult = $_FILES['tagalog_adult_audio']['name'];
    $englishMinor = $_FILES['english_minor_audio']['name'];
    $englishAdult = $_FILES['english_adult_audio']['name'];

    $tagalogMinorPath = 'uploads/audio/' . $tagalogMinor;
    $tagalogAdultPath = 'uploads/audio/' . $tagalogAdult;
    $englishMinorPath = 'uploads/audio/' . $englishMinor;
    $englishAdultPath = 'uploads/audio/' . $englishAdult;

    move_uploaded_file($_FILES['tagalog_minor_audio']['tmp_name'], $tagalogMinorPath);
    move_uploaded_file($_FILES['tagalog_adult_audio']['tmp_name'], $tagalogAdultPath);
    move_uploaded_file($_FILES['english_minor_audio']['tmp_name'], $englishMinorPath);
    move_uploaded_file($_FILES['english_adult_audio']['tmp_name'], $englishAdultPath);

    // Insert to DB (Make sure you add these columns in your `diorama` table!)
    $stmt = $conn->prepare("INSERT INTO diorama 
        (name, picture, 
         description_english_minor, description_english_adult, 
         description_tagalog_minor, description_tagalog_adult, 
         tagalog_minor_audio, tagalog_adult_audio, 
         english_minor_audio, english_adult_audio) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("ssssssssss", $name, $imagePath, 
        $description_english_minor, $description_english_adult, 
        $description_tagalog_minor, $description_tagalog_adult, 
        $tagalogMinorPath, $tagalogAdultPath, 
        $englishMinorPath, $englishAdultPath);

    $stmt->execute();
    $lastId = $stmt->insert_id;

    // QR Code Generation
    $qrText = "diorama_id_" . $lastId;
    $qrPath = "uploads/qrcodes/qrcode_$lastId.png";
    QRcode::png($qrText, $qrPath, QR_ECLEVEL_H, 4);

    echo "<script>alert('Diorama Created Successfully!');</script>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Create Diorama</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    .container {
      max-width: 900px;
      margin-top: 20px;
      margin-bottom: 20px;
    }
    .form-group label {
      font-weight: 600;
    }
    .audio-container, .description-container {
      background-color: #f8f9fa;
      border-radius: 8px;
      padding: 15px;
      margin-bottom: 20px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .section-title {
      background-color: #6c757d;
      color: white;
      padding: 8px 15px;
      border-radius: 5px;
      margin-bottom: 15px;
      font-weight: 500;
    }
    .audio-label, .description-label {
      color: #495057;
      margin-bottom: 6px;
    }
    .file-info {
      margin-top: 5px;
      font-size: 0.85rem;
      color: #6c757d;
    }
    .custom-file-label::after {
      content: "Browse";
    }
    .btn-success {
      background-color: #28a745;
      border-color: #28a745;
      padding: 10px;
      font-weight: 500;
    }
    .btn-success:hover {
      background-color: #218838;
      border-color: #1e7e34;
    }
    .form-title {
      color: #343a40;
      border-bottom: 2px solid #28a745;
      padding-bottom: 10px;
      margin-bottom: 25px;
    }
  </style>
</head>
<body>
  <div class="container bg-white p-5 shadow rounded">
    <h3 class="text-center form-title">Create Diorama</h3>
    <form method="POST" enctype="multipart/form-data">
      <div class="form-group mb-3">
        <label for="name">Name:</label>
        <input required type="text" class="form-control" name="name" id="name">
      </div>
      <div class="form-group mb-3">
        <label for="picture">Picture:</label>
        <div class="custom-file">
          <input required type="file" class="custom-file-input" name="picture" id="picture" accept="image/*">
          <label class="custom-file-label" for="picture">Choose file...</label>
        </div>
      </div>
      
      <!-- Description Section - Split into English and Filipino -->
      <div class="row description-container">
        <div class="col-md-12">
          <h4 class="mb-3">Descriptions</h4>
        </div>
        
        <!-- Left Column for English Descriptions -->
        <div class="col-md-6">
          <div class="section-title">English Descriptions</div>
          
          <div class="form-group mb-3">
            <label class="description-label">English - Minor Description:</label>
            <textarea required class="form-control" name="description_english_minor" id="description_english_minor" rows="4"></textarea>
          </div>
          
          <div class="form-group mb-3">
            <label class="description-label">English - Adult Description:</label>
            <textarea required class="form-control" name="description_english_adult" id="description_english_adult" rows="4"></textarea>
          </div>
        </div>
        
        <!-- Right Column for Filipino Descriptions -->
        <div class="col-md-6">
          <div class="section-title">Filipino Descriptions</div>
          
          <div class="form-group mb-3">
            <label class="description-label">Filipino - Minor Description:</label>
            <textarea required class="form-control" name="description_tagalog_minor" id="description_tagalog_minor" rows="4"></textarea>
          </div>
          
          <div class="form-group mb-3">
            <label class="description-label">Filipino - Adult Description:</label>
            <textarea required class="form-control" name="description_tagalog_adult" id="description_tagalog_adult" rows="4"></textarea>
          </div>
        </div>
      </div>
      
      <!-- Audio Files Section - Split into two columns -->
      <div class="row audio-container">
        <div class="col-md-12">
          <h4 class="mb-3">Audio Files</h4>
        </div>
        
        <!-- Left Column for Filipino Audio -->
        <div class="col-md-6">
          <div class="section-title">Filipino Audio Files</div>
          
          <div class="form-group mb-3">
            <label class="audio-label">Filipino - Minor Audio:</label>
            <div class="custom-file">
              <input type="file" class="custom-file-input" name="tagalog_minor_audio" id="tagalog_minor_audio" accept="audio/*" onchange="updateFileInfo(this, 'tagalog-minor-info')">
              <label class="custom-file-label" for="tagalog_minor_audio">Choose file...</label>
            </div>
            <div id="tagalog-minor-info" class="file-info"></div>
          </div>
          
          <div class="form-group mb-3">
            <label class="audio-label">Filipino - Adult Audio:</label>
            <div class="custom-file">
              <input type="file" class="custom-file-input" name="tagalog_adult_audio" id="tagalog_adult_audio" accept="audio/*" onchange="updateFileInfo(this, 'tagalog-adult-info')">
              <label class="custom-file-label" for="tagalog_adult_audio">Choose file...</label>
            </div>
            <div id="tagalog-adult-info" class="file-info"></div>
          </div>
        </div>
        
        <!-- Right Column for English Audio -->
        <div class="col-md-6">
          <div class="section-title">English Audio Files</div>
          
          <div class="form-group mb-3">
            <label class="audio-label">English - Minor Audio:</label>
            <div class="custom-file">
              <input type="file" class="custom-file-input" name="english_minor_audio" id="english_minor_audio" accept="audio/*" onchange="updateFileInfo(this, 'english-minor-info')">
              <label class="custom-file-label" for="english_minor_audio">Choose file...</label>
            </div>
            <div id="english-minor-info" class="file-info"></div>
          </div>
          
          <div class="form-group mb-3">
            <label class="audio-label">English - Adult Audio:</label>
            <div class="custom-file">
              <input type="file" class="custom-file-input" name="english_adult_audio" id="english_adult_audio" accept="audio/*" onchange="updateFileInfo(this, 'english-adult-info')">
              <label class="custom-file-label" for="english_adult_audio">Choose file...</label>
            </div>
            <div id="english-adult-info" class="file-info"></div>
          </div>
        </div>
      </div>

      <button type="submit" class="btn btn-success btn-block">Create Diorama</button>
    </form>
  </div>

  <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Display file name on file selection
    $('.custom-file-input').on('change', function() {
      var fileName = $(this).val().split('\\').pop();
      $(this).next('.custom-file-label').html(fileName);
    });
    
    // Show file size of selected audio files
    function updateFileInfo(input, infoId) {
      const info = document.getElementById(infoId);
      const maxSize = 3 * 1024 * 1024; // 3 MB

      if (input.files && input.files[0]) {
        const file = input.files[0];

        if (file.size > maxSize) {
          Swal.fire({
                icon: 'error',
                title: 'Upload Error',
                text: 'The selected file is too large. Maximum allowed size is 3 MB.',
                confirmButtonColor: '#d33',
                confirmButtonText: 'Try Again'
            }).then(() => {
                input.value = ""; // Reset file input
                document.querySelector(`label[for="${input.id}"]`).textContent = "Choose file...";
            });
            return;
        }

        const fileSizeMB = (file.size / (1024 * 1024)).toFixed(2);

        info.innerHTML = `File Size: <strong>${fileSizeMB} MB</strong> | Type: ${file.type}`;
      } else {
        info.innerHTML = '';
      }
    }
    
    // Also handle the picture file
    document.getElementById('picture').addEventListener('change', function() {
      const label = this.nextElementSibling;
      if (this.files && this.files[0]) {
        label.textContent = this.files[0].name;
      } else {
        label.textContent = 'Choose file...';
      }
    });
  </script>
</body>
</html>