

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Diorama List</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: #f4f6f9;
      padding: 30px;
    }
    .card {
      border-radius: 15px;
      transition: 0.3s;
    }
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.1);
    }
    .qr-img {
      height: 100px;
      width: 100px;
      object-fit: cover;
    }
    .diorama-img {
      height: 150px;
      object-fit: contain;
      border-radius: 10px;
      box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.1);
    }
    .card-title {
      font-weight: bold;
    }
    .btn {
      border-radius: 20px;
    }
  </style>
</head>
<body>

  <div class="container">
    <h2 class="text-center mb-4"><i class="fas fa-cube me-2"></i> Diorama List</h2>
    <div class="row g-4">

      <?php
      $dioramas = $conn->query("SELECT * FROM diorama ORDER BY id DESC");
      while ($row = $dioramas->fetch_assoc()):
        $qrPath = 'uploads/qrcodes/qrcode_' . $row['id'] . '.png';
      ?>
        <div class="col-md-4">
          <div class="card shadow-sm p-3">
            <?php if ($row['picture']): ?>
              <img src="<?php echo $row['picture'] ?>" alt="Diorama" class="diorama-img w-100 mb-3" style="display: contain;">
            <?php endif; ?>
            <h5 class="card-title"><?php echo htmlspecialchars($row['name']) ?></h5>
            <p class="card-text text-muted"><?php echo substr($row['description_english_minor'], 0, 40) ?>...</p>

            <div class="mb-3 text-center">
              <img src="<?php echo $qrPath ?>" alt="QR Code" class="qr-img">
              <p class="small text-muted mb-0">QR Code</p>
            </div>

            <div class="d-flex justify-content-between">
              <a href="./index.php?page=view_diorama&id=<?php echo $row['id'] ?>" class="btn btn-info btn-sm">
                <i class="fas fa-eye"></i> View
              </a>
              <a href="./index.php?page=edit_diorama&id=<?php echo $row['id'] ?>" class="btn btn-warning btn-sm">
                <i class="fas fa-edit"></i> Edit
              </a>
                <a href="delete_diorama.php?id=<?php echo $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this diorama?');">
                <i class="fas fa-trash"></i> Delete
              </a>
            </div>
          </div>
        </div>
      <?php endwhile; ?>

    </div>
  </div>

</body>
</html>
