
<?php
if (!isset($_GET['id'])) {
  echo "Invalid ID";
  exit;
}
 include('../db_connect.php');
$id = $_GET['id'];
$diorama = $conn->query("SELECT * FROM diorama WHERE id = $id")->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>View Diorama</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    .wrappers {
      width: 100%;
      max-width: 1200px;
      background: #ffffff;
      border-radius: 20px;
      padding: 40px;
      box-shadow: 0 12px 30px rgba(0, 0, 0, 0.1);
    }

    .back-btn {
      text-decoration: none;
      display: inline-block;
      margin-bottom: 20px;
      color: #555;
      font-weight: 500;
      transition: 0.3s;
    }

    .back-btn:hover {
      color: #000;
    }

    h2 {
      text-align: center;
      margin-bottom: 30px;
      font-size: 2rem;
      color: #2c3e50;
    }

    .top-section {
      display: flex;
      flex-wrap: wrap;
      justify-content: space-between;
      gap: 30px;
    }

    .image-container,
    .audio-container {
      flex: 1 1 40%;
      min-width: 300px;
    }

    .image-container img {
      width: 100%;
      height: 300px;
      object-fit: cover;
      border-radius: 15px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    .qr-container {
      display: flex;
      justify-content: center;
      align-items: center;
      min-width: 100px;
    }

    .qr-container img {
      width: 120px;
      height: 120px;
      border-radius: 10px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .audio-container h5 {
      margin-bottom: 5px;
      color: #34495e;
    }

    .audio-container audio {
      width: 100%;
      margin-bottom: 15px;
      border-radius: 6px;
      outline: none;
    }

    .description {
      margin-top: 30px;
      background: #f5f7fa;
      padding: 20px;
      border-radius: 12px;
      box-shadow: inset 0 0 5px rgba(0, 0, 0, 0.05);
      font-size: 1rem;
      line-height: 1.6;
      color: #333;
    }

    .description-section {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      margin-top: 30px;
    }

    .description-container {
      flex: 1;
      min-width: 300px;
    }

    .language-title {
      font-size: 1.3rem;
      margin-bottom: 15px;
      color: #2c3e50;
      border-bottom: 2px solid #3498db;
      padding-bottom: 5px;
    }

    .audience-title {
      font-size: 1.1rem;
      margin: 15px 0 10px;
      color: #34495e;
      font-weight: 600;
    }

    @media (max-width: 768px) {
      .top-section {
        flex-direction: column;
        align-items: center;
      }

      .qr-container {
        margin: 20px 0;
      }
    }
  </style>
</head>
<body>
  <div class="wrappers">

    <h2><?php echo htmlspecialchars($diorama['name']) ?></h2>

    <div class="top-section">
      <div class="image-container">
        <img src="<?php echo $diorama['picture'] ?>" alt="Diorama Image">
      </div>

      <div class="qr-container">
        <img src="uploads/qrcodes/qrcode_<?php echo $diorama['id'] ?>.png" alt="QR Code">
      </div>

      <div class="audio-container">
        <h5>Filipino - Minor</h5>
        <audio controls src="<?php echo $diorama['tagalog_minor_audio'] ?>"></audio>

        <h5>Filipino - Adult</h5>
        <audio controls src="<?php echo $diorama['tagalog_adult_audio'] ?>"></audio>

        <h5>English - Minor</h5>
        <audio controls src="<?php echo $diorama['english_minor_audio'] ?>"></audio>

        <h5>English - Adult</h5>
        <audio controls src="<?php echo $diorama['english_adult_audio'] ?>"></audio>
      </div>
    </div>

    <!-- English Descriptions -->
    <div class="description-section">
      <div class="description-container">
        <h4 class="language-title">English Descriptions</h4>
        
        <div class="description">
          <h5 class="audience-title">Minor Description</h5>
          <?php echo nl2br(htmlspecialchars($diorama['description_english_minor'])) ?>
        </div>
        
        <div class="description">
          <h5 class="audience-title">Adult Description</h5>
          <?php echo nl2br(htmlspecialchars($diorama['description_english_adult'])) ?>
        </div>
      </div>

      <!-- Filipino Descriptions -->
      <div class="description-container">
        <h4 class="language-title">Filipino Descriptions</h4>
        
        <div class="description">
          <h5 class="audience-title">Minor Description</h5>
          <?php echo nl2br(htmlspecialchars($diorama['description_tagalog_minor'])) ?>
        </div>
        
        <div class="description">
          <h5 class="audience-title">Adult Description</h5>
          <?php echo nl2br(htmlspecialchars($diorama['description_tagalog_adult'])) ?>
        </div>
      </div>
    </div>
  </div>
</body>
</html>