<!DOCTYPE html>
<html lang="en">
<?php 
session_start();
include('../db_connect.php');
ob_start();
$system = $conn->query("SELECT * FROM system_settings")->fetch_array();
foreach($system as $k => $v){
  $_SESSION['system'][$k] = $v;
}
ob_end_flush();
?>
<?php 
if(isset($_SESSION['login_id']))
  header("location:index.php?page=home");
?>
<?php include 'header.php' ?>
<body class="login-page" style="background: linear-gradient(to right, #4facfe, #00f2fe); font-family: 'Poppins', sans-serif;">

  <div class="container" style="margin-top: 60px;">
    <!-- System Title -->
    <h2 class="text-center mb-4" style="color: white; font-weight: bold; font-size: 2.5rem;">
    iStorya
    </h2>

    <!-- Login Card -->
    <div class="card mx-auto shadow-lg" style="max-width: 450px; border-radius: 20px;">
      <div class="card-body p-5">

        <!-- Avatar/Icon -->
        <div class="text-center mb-4">
          <img src="../logos.png" alt="" style="width: 120px; height: 120px; object-fit: cover; border-radius: 0%; box-shadow: 0 4px 8px rgba(0,0,0,0.2);">
          <h4 class="mt-3" style="color: #4facfe;">Admin Login</h4>
        </div>

        <!-- Login Form -->
        <form action="" id="login-form">

          <!-- Student ID Field -->
          <div class="form-group" id="student-id-field" style="display: none;">
            <label>Student ID</label>
            <div class="input-group">
              <input type="text" class="form-control rounded-left" name="school_id" placeholder="Enter your Student ID">
              <div class="input-group-append">
                <span class="input-group-text rounded-right"><i class="fas fa-id-card"></i></span>
              </div>
            </div>
          </div>

          <!-- Email Field -->
          <div class="form-group" id="email-field">
            <label>Email</label>
            <div class="input-group">
              <input type="email" class="form-control rounded-left" name="email" placeholder="Email" required>
              <div class="input-group-append">
                <span class="input-group-text rounded-right"><i class="fas fa-envelope"></i></span>
              </div>
            </div>
          </div>

          <!-- Password Field -->
          <div class="form-group" id="password-field">
            <label>Password</label>
            <div class="input-group">
              <input type="password" class="form-control rounded-left" name="password" placeholder="Password" required>
              <div class="input-group-append">
                <span class="input-group-text rounded-right"><i class="fas fa-lock"></i></span>
              </div>
            </div>
          </div>

          <!-- Role Selector -->
          <div class="form-group" style="display: none;">
            <label>Login As</label>
            <select name="login" id="login-role" class="custom-select">
    
              <option value="1">Admin</option>
            </select>
          </div>

          <!-- Remember Me & Sign In -->
          <div class="form-group d-flex justify-content-between align-items-center">
            <!--<div class="icheck-primary">-->
            <!--  <input type="checkbox" id="remember">-->
            <!--  <label for="remember" style="font-weight: 400;">Remember Me</label>-->
            <!--</div>-->
            <button type="submit" class="btn btn-primary" style="border-radius: 30px; padding: 8px 20px; background-color: #4facfe; border: none;">
              Sign In
            </button>
          </div>

        </form>

      </div>
    </div>
  </div>

<script>
  $(document).ready(function(){
    $('#login-role').change(function(){
      if($(this).val() == '3'){ // Student
        $('#email-field, #password-field').hide();
        $('#student-id-field').show().find('input').prop('required', true);
        $('#email-field input, #password-field input').prop('required', false);
      } else {
        $('#student-id-field').hide();
        $('#email-field, #password-field').show();
        $('#student-id-field input').prop('required', false);
        $('#email-field input, #password-field input').prop('required', true);
      }
    });

    $('#login-role').trigger('change');

    $('#login-form').submit(function(e){
      e.preventDefault();
      start_load();
      if($(this).find('.alert-danger').length > 0)
        $(this).find('.alert-danger').remove();

      $.ajax({
        url: 'ajax.php?action=login',
        method: 'POST',
        data: $(this).serialize(),
        error: err => {
          console.log(err);
          end_load();
        },
        success: function(resp){
          if(resp == 1){
            location.href = 'index.php?page=home';
          } else {
            $('#login-form').prepend('<div class="alert alert-danger">Login information is incorrect.</div>');
            end_load();
          }
        }
      });
    });
  });
</script>
<?php include 'footer.php' ?>
</body>
</html>
