<?php
 include('../db_connect.php');

// Include the Semaphore API
$api_key = '415f312b50893a29ba4c9a1f6f8c9b25'; // Replace with your actual Semaphore API key

function hashPassword($password)
{
    return hash('sha256', $password);
}

function generateOTP()
{
    return rand(100000, 999999);
}

function sendOTP($phone, $otp)
{
    global $api_key;

    $ch = curl_init();
    $message = "Your OTP for login verification is: $otp\n\nDo not share your OTP."; // Include the "Do not share your OTP" message
    $parameters = array(
        'apikey' => $api_key,
        'number' => $phone, // Replace with the recipient's phone number
        'message' => $message,
        'sendername' => 'SEMAPHORE'
    );

    curl_setopt($ch, CURLOPT_URL, 'https://semaphore.co/api/v4/messages');
    curl_setopt($ch, CURLOPT_POST, 1);

    // Send the parameters set above with the request
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($parameters));

    // Receive response from the server
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($ch);
    curl_close($ch);

    // Show the server response
    return $output;
}


function updateOTPInStudentTable($email, $otp)
{
    $conn = getDBConnection();

    $sql = "UPDATE student SET otp=? WHERE email=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $otp, $email);
    $stmt->execute();

    $stmt->close();
    $conn->close();
}
function login($userType, $email, $password)
{
    $conn = getDBConnection();

    switch ($userType) {
        case 'admin':
            $table = 'admin';
            break;
        case 'faculty':
            $table = 'faculty';
            break;
        case 'student':
            $table = 'student';
            break;
        default:
            return "Invalid user type.";
    }

    $hashedInputPassword = hashPassword($password);

        $sql = "SELECT password, phone FROM $table WHERE email=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->bind_result($hashedStoredPassword, $phone);
        $stmt->fetch();
        $stmt->close();

        if ($hashedInputPassword === $hashedStoredPassword) {
            session_start();
            $_SESSION['user_authenticated'] = true;
            $_SESSION['user_type'] = $userType;
            $_SESSION['email'] = $email;

            if ($userType === 'student') {
                $otp = generateOTP();
                $_SESSION['otp'] = $otp;
                sendOTP($phone, $otp);
                updateOTPInStudentTable($email, $otp);
                return "success";

            }
        } else {
            return "Invalid credentials for $userType.";
        }

        $conn->close();
    }

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $userType = $_POST["user_type"];
    $email = $_POST["email"];
    $password = $_POST["password"];
    $response = login($userType, $email, $password);

    // Check the response and handle it accordingly
    if ($response === "success") {
        echo $response;
    } else if ($response === "Invalid credentials for $userType.") {
        echo $response;
    } else {
        // For admin and faculty, return the corresponding URL
        switch ($userType) {
            case 'admin':
                echo "admin/home.php";
                break;
            case 'faculty':
                echo "faculty/home.php";
                break;
            default:
                echo $response;
        }
    }
}
?>