<?php
// save_assessment_answers.php
header("Content-Type: application/json");
include("api/db_connect.php"); // adjust path if needed

// Read JSON input
$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (!$data || !isset($data['name']) || !isset($data['answers'])) {
    echo json_encode(["status" => "error", "message" => "Invalid data"]);
    exit;
}

$name = $data['name'];
$answers = $data['answers'];

// Insert answers into DB
foreach ($answers as $ans) {
    $qid = intval($ans['question_id']);
    $answer = intval($ans['answer']);

    $stmt = $conn->prepare("INSERT INTO assessment_answers (user_name, question_id, answer) VALUES (?, ?, ?)");
    if ($stmt) {
        $stmt->bind_param("sii", $name, $qid, $answer);
        $stmt->execute();
        $stmt->close();
    }
}

echo json_encode(["status" => "success", "message" => "Answers saved successfully."]);
?>
