<?php include('db_connect.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Diorama</title>

  <!-- Local Libraries -->
  <link href="libs/bootstrap.min.css" rel="stylesheet">
  <link href="libs/all.min.css" rel="stylesheet">

  <!-- Poppins Fonts -->
  <style>
    @font-face {
      font-family: 'Poppins';
      src: url('fonts/Poppins-Regular.ttf') format('truetype');
      font-weight: normal;
    }
    @font-face {
      font-family: 'Poppins';
      src: url('fonts/Poppins-SemiBold.ttf') format('truetype');
      font-weight: 600;
    }
 body {
    background: #f0f3f8;
    font-family: 'Poppins', sans-serif;
    padding-top: 30px;
    color: #333;
    margin: 0;
    padding: 0;
    min-height: 100vhFili
  }

  .container {
    max-width: 480px;
    margin: 0 auto;
    padding: 20px 15px;
  }

  .text-muted {
    color: #6c757d !important;
  }

  .scanner-card {
    background: #ffffff;
    border-radius: 20px;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
    padding: 20px;
    margin-bottom: 20px;
    position: relative;
  }

  .card-img-top {
    max-height: 260px;
    object-fit: cover;
    border-top-left-radius: 20px;
    border-top-right-radius: 20px;
  }

  .card {
    border: none;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
  }

  .card-body {
    padding: 1.8rem;
  }

  .card-footer {
    background: transparent;
    border-top: 1px solid rgba(0,0,0,0.05);
    padding: 1rem 1.8rem;
  }

  .btn {
    border-radius: 50px;
    padding: 12px 24px;
    font-weight: 600;
    letter-spacing: 0.3px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
  }

  .btn::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 5px;
    height: 5px;
    background: rgba(255, 255, 255, 0.3);
    opacity: 0;
    border-radius: 100%;
    transform: scale(1, 1) translate(-50%);
    transform-origin: 50% 50%;
  }

  .btn:hover::after {
    animation: ripple 1s ease-out;
  }

  @keyframes ripple {
    0% {
      transform: scale(0, 0);
      opacity: 0.3;
    }
    100% {
      transform: scale(40, 40);
      opacity: 0;
    }
  }

  .btn-primary {
    background: #4361ee;
    border-color: #4361ee;
    box-shadow: 0 4px 15px rgba(67, 97, 238, 0.2);
  }

  .btn-success {
    background: #2dce89;
    border-color: #2dce89;
    box-shadow: 0 4px 15px rgba(45, 206, 137, 0.2);
  }

  .btn-secondary {
    background: #6c757d;
    border-color: #6c757d;
    box-shadow: 0 4px 15px rgba(108, 117, 125, 0.2);
  }

  .btn-primary:hover, .btn-success:hover, .btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 18px rgba(0, 0, 0, 0.15);
  }

  #scanner {
    width: 100%;
    max-width: 450px;
    margin: auto;
    display: none;
    border-radius: 20px;
    overflow: hidden;
  }

  #resultCard {
    display: none;
  }

  .modal-content {
    border-radius: 20px;
    border: none;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
  }

  .modal-header {
    border-bottom: none;
    padding: 20px 25px 10px;
  }

  .modal-body {
    padding: 20px 25px;
  }

  .modal-footer {
    border-top: none;
    padding: 10px 25px 20px;
  }

  .question-block {
    background: #f9fafb;
    border: 1px solid #e3e6ea;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 3px 10px rgba(0, 0, 0, 0.03);
    transition: all 0.3s ease;
  }

  .question-block:hover {
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    transform: translateY(-2px);
  }

  .form-check {
    margin: 12px 0;
    padding-left: 30px;
  }

  .form-check-input {
    width: 20px;
    height: 20px;
    margin-left: -30px;
    margin-top: 2px;
    cursor: pointer;
  }

  .form-check-input:checked {
    background-color: #2dce89;
    border-color: #2dce89;
  }

  .form-check-label {
    margin-left: 8px;
    cursor: pointer;
    padding: 3px 0;
  }

  .bg-success {
    background-color: #2dce89 !important;
  }

  .text-white {
    color: white !important;
  }

  .alert-info {
    border-radius: 16px;
    font-weight: 500;
    background-color: #e9f5ff;
    border: 1px solid #cfe2ff;
    padding: 15px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.03);
  }

  .btn-close {
    box-shadow: none !important;
  }

  /* Audio Player Styling */
  audio {
    width: 100%;
    border-radius: 50px;
    margin-top: 10px;
  }

  audio::-webkit-media-controls-panel {
    background: #f0f3f8;
  }

  .modal-title {
    font-weight: 600;
  }

  /* Language Selection Styling */
  .language-btn {
    width: 45%;
    padding: 15px;
    font-size: 1.1em;
    transition: all 0.3s ease;
  }

  .language-btn:hover {
    transform: translateY(-3px);
  }
  
  /* Header with app icon */
  .app-header {
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
  }
  
  .app-icon {
    font-size: 28px;
    background: #4361ee;
    color: white;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 15px;
    margin-right: 12px;
    box-shadow: 0 4px 15px rgba(67, 97, 238, 0.2);
  }
  
  .app-title {
    font-weight: 700;
    font-size: 22px;
    margin: 0;
  }
  
  /* Bottom navigation bar */
  .bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: white;
    display: flex;
    justify-content: space-around;
    padding: 12px 0;
    box-shadow: 0 -2px 15px rgba(0, 0, 0, 0.05);
    border-top-left-radius: 20px;
    border-top-right-radius: 20px;
    z-index: 1000;
  }
  
  .nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: #6c757d;
    text-decoration: none;
    font-size: 0.8rem;
    padding: 8px 0;
    transition: all 0.3s ease;
  }
  
  .nav-item.active {
    color: #4361ee;
  }
  
  .nav-icon {
    font-size: 22px;
    margin-bottom: 5px;
  }
  
  /* Floating scan button */
  .scan-fab {
    position: fixed;
    bottom: 80px;
    right: 20px;
    width: 60px;
    height: 60px;
    border-radius: 30px;
    background: #4361ee;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 20px rgba(67, 97, 238, 0.4);
    z-index: 1001;
    border: none;
    font-size: 24px;
    transition: all 0.3s ease;
  }
  
  .scan-fab:hover {
    transform: scale(1.05);
    box-shadow: 0 6px 25px rgba(67, 97, 238, 0.5);
  }
  
  /* Add bottom padding to compensate for the nav bar */
  body {
    padding-bottom: 70px;
  }
</style>
</head>
<body>

<div class="container">
  <div class="app-header">
    <div class="app-icon">
      <i class="fas fa-qrcode"></i>
    </div>
    <h3 class="app-title">Diorama Scanner</h3>
  </div>

  <div id="soloReminder" class="alert alert-info text-center mx-3 mb-4" style="display: none;">
    <i class="fas fa-headphones me-2"></i> <strong>Reminder:</strong> Please wear your earphones for a better experience.
  </div>

  <div id="scannerSection" 
     style="
       position: fixed;
       top: 50%;
       left: 50%;
       transform: translate(-50%, -50%);
       width: 100%;
       max-width: 400px;
       text-align: center;
       z-index: 9999;
     ">
  <p class="text-muted">Use your camera to scan the QR code on the Diorama.</p>
  <button id="startScanBtn" class="btn btn-primary" onclick="startScanner()">
    <i class="fas fa-camera me-2"></i> Start Scanning
  </button>
</div>


  <div id="scanner" class="scanner-card"></div>

  <div id="resultCard" class="card mt-4 shadow">
    <img src="" id="dioramaImage" class="card-img-top">
    <div class="card-body">
      <h5 class="card-title" id="dioramaName"></h5>
      <p class="card-text" id="dioramaDesc"></p>
      <audio id="dioramaAudio" controls autoplay></audio>
    </div>
    <div class="card-footer text-center" id="resultButtons">
  <button class="btn btn-secondary me-2" id="scanAgainBtn" onclick="startScanner()">
    <i class="fas fa-qrcode me-2"></i> Scan Again
  </button>
  <button class="btn btn-primary d-none" id="nextDioramaBtn" onclick="startNextDiorama()">
    <i class="fas fa-arrow-right me-2"></i> Next Diorama
  </button>
</div>

  </div>
</div>

<!-- Language Selection Modal -->
<div class="modal fade" id="languageModal" tabindex="-1" aria-labelledby="languageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="languageModalLabel"><i class="fas fa-language me-2"></i> Choose Language</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body text-center">
        <button class="btn btn-outline-primary m-2 language-btn" onclick="selectLanguage('English')">
          <i class="fas fa-globe-americas me-2"></i> English
        </button>
        <button class="btn btn-outline-success m-2 language-btn" onclick="selectLanguage('tagalog')">
          <i class="fas fa-globe-asia me-2"></i> Filipino
        </button>
      </div>
    </div>
  </div>
</div>

<!-- Assessment Review Modal -->
<div class="modal fade" id="reviewModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="assessmentForm">
        <div class="modal-header">
          <h5 class="modal-title"><i class="fas fa-clipboard-list me-2"></i> Diorama Assessment</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body" id="questionsContainer"></div>
        <div class="modal-footer">
          <button type="submit" id="submitAnswersBtn" class="btn btn-success">
            <i class="fas fa-paper-plane me-2"></i> Submit Answers
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Confirm Assessment Modal -->
<div class="modal fade" id="confirmAssessmentModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content text-center">
      <div class="modal-header">
        <h5 class="modal-title">
          <i class="fas fa-question-circle me-2"></i> Take Assessment?
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <p class="mb-3">
          Would you like to take an assessment for this Diorama?
        </p>
        <div class="alert alert-info rounded-3 shadow-sm">
          <i class="fas fa-gift text-warning me-2"></i>
          <strong>Good luck!</strong> Show what you’ve learned — complete the assessment and earn a special reward! 🎁
        </div>
      </div>

      <div class="modal-footer justify-content-center">
        <button class="btn btn-success" onclick="openAssessmentReview()">
          <i class="fas fa-check me-2"></i> Yes, let’s go!
        </button>
        <<button class="btn btn-secondary" data-bs-dismiss="modal">
  <i class="fas fa-times me-2"></i> Not now
</button>

      </div>
    </div>
  </div>
</div>


<!-- Floating Scan Button -->
<button class="scan-fab" onclick="startScanner()">
  <i class="fas fa-qrcode"></i>
</button>

<!-- Local JS Libraries -->
<script src="libs/sweetalert2.all.min.js"></script>
<script src="libs/dexie.min.js"></script>
<script src="libs/html5-qrcode.min.js"></script>
<script src="libs/bootstrap.bundle.min.js"></script>
<script>

// ✅ 2. Global Variables
let scanner;
let currentQuestions = [];
let currentDioramaId = null;
let selectedLanguage = "tagalog";
let appMode = "online"; // or detect automatically
let age = localStorage.getItem('age') || 20;


async function stopScanner() {
  if (scanner) {
    try {
      await scanner.stop();
      console.log("🛑 Scanner fully stopped.");
    } catch (err) {
      console.warn("⚠️ Error stopping scanner:", err);
    }
  }
}


// ✅ 3. QR Scanner Function (Restored)
async function startScanner() {
  try {
    console.log("📷 Starting QR scanner...");
    document.getElementById('resultCard').style.display = 'none';
    document.getElementById('scanner').style.display = 'block';
    document.getElementById('startScanBtn').style.display = 'none';

    if (!scanner) scanner = new Html5Qrcode("scanner");

    const devices = await Html5Qrcode.getCameras();
    if (!devices || devices.length === 0) {
      alert("No camera found on this device.");
      return;
    }

    const backCamera = devices.find(d => d.label.toLowerCase().includes("back")) || devices[0];

    await scanner.start(
      { deviceId: { exact: backCamera.id } },
      { fps: 10, qrbox: { width: 250, height: 250 } },
      (decodedText) => {
        console.log("📷 QR Code scanned:", decodedText);

        let id = null;
        if (decodedText.includes("diorama_id_")) {
          id = decodedText.split("diorama_id_")[1];
        } else if (decodedText.includes("?id=")) {
          try {
            id = new URL(decodedText).searchParams.get("id");
          } catch (err) {
            console.warn("⚠️ Could not parse URL from QR:", decodedText);
          }
        }

        if (!id) {
          alert("Invalid QR Code format.");
          return;
        }
        stopScanner().then(() => {
          currentDioramaId = id;
          console.log("✅ QR parsed, Diorama ID =", currentDioramaId);
          new bootstrap.Modal(document.getElementById('languageModal')).show();
        });

      },
      (error) => {
        // ignore frequent "not found" errors during scanning
      }
    );
  } catch (err) {
    console.error("❌ QR Scanner failed:", err);
    alert("Unable to access camera. Please allow camera permission and reload.");
  }
}

// ✅ 4. Language Selection
function selectLanguage(lang) {
  selectedLanguage = lang.toLowerCase();
  localStorage.setItem('user_language', selectedLanguage);
  bootstrap.Modal.getInstance(document.getElementById('languageModal')).hide();
  fetchDiorama(currentDioramaId, selectedLanguage);
}

// ✅ 5. Fetch Diorama and Play Audio
function fetchDiorama(id) {
  console.log("📡 Fetching Diorama ID:", id);
  fetch("get_diorama.php?id=" + id)
    .then(response => response.json())
    .then(data => {
      console.log("📦 Diorama Loaded:", data);
      showDiorama(data);
    })
    .catch(err => console.error("❌ Error loading Diorama:", err));
}

function showDiorama(data) {
  document.getElementById('dioramaName').textContent = data.name;
  document.getElementById('dioramaDesc').textContent = getDescriptionSource(data, selectedLanguage);

  // ✅ Show the picture
  const img = document.getElementById('dioramaImage');
  img.src = data.image; // Make sure your PHP returns `image` with the full URL
  img.alt = data.name;

  const audio = document.getElementById('dioramaAudio');
  const audioSrc = getAudioSource(data, selectedLanguage);
  audio.src = audioSrc;
  console.log(`🎵 Playing audio: ${audioSrc}`);
  audio.play();

  document.getElementById('scanner').style.display = 'none';
  document.getElementById('resultCard').style.display = 'block';

  audio.onended = () => {
      stopScanner(); // make sure scanner stays off while user is on Diorama

  console.log("🎵 Audio finished, fetching assessment questions...");

  if (appMode === "online") {
    fetch(`get_assessment_questions.php?diorama_id=${currentDioramaId}&language=${selectedLanguage}`)
      .then(res => res.json())
      .then(data => {
        handleQuestions(data);
        // ✅ Show "Next" button even if user skips the assessment
        setTimeout(() => {
          document.getElementById('nextDioramaBtn').classList.remove('d-none');
        }, 2000);
      })
      .catch(() => {
        // If assessment fetch fails, still show the button
        document.getElementById('nextDioramaBtn').classList.remove('d-none');
      });
  } else {
    // ✅ Offline mode — directly show "Next"
    document.getElementById('nextDioramaBtn').classList.remove('d-none');
  }
};

}


// ✅ 6. Handle Questions & Modals
function handleQuestions(data) {
  console.log(`📦 Loaded ${data.length} question(s).`);
  if (data.length > 0) {
    currentQuestions = data;
    new bootstrap.Modal(document.getElementById('confirmAssessmentModal')).show();
  } else {
    console.log('ℹ️ No assessment questions for this Diorama.');
  }
}

function openAssessmentReview() {
  console.log("📝 Opening Assessment Review...");
  bootstrap.Modal.getInstance(document.getElementById('confirmAssessmentModal')).hide();

  const container = document.getElementById('questionsContainer');
  container.innerHTML = '';

  currentQuestions.forEach((question, index) => {
    container.innerHTML += `
      <div class="mb-3 question-block" data-question-id="${question.id}" data-correct="${question.correct_answer}">
        <strong>Q${index + 1}. ${question.question}</strong>
        <input type="hidden" name="question_ids[]" value="${question.id}">
        ${['a', 'b', 'c', 'd'].map(opt => `
          <div class="form-check">
            <input class="form-check-input" type="radio" name="answer_${question.id}" value="${opt}" required>
            <label class="form-check-label">${question[opt]}</label>
          </div>
        `).join('')}
      </div>
    `;
  });

  new bootstrap.Modal(document.getElementById('reviewModal')).show();
  console.log("✅ Review modal opened.");
}

// ✅ 7. Submit Answers
document.getElementById('assessmentForm').addEventListener('submit', async function(e) {
  e.preventDefault();
  const formData = new FormData(this);
  const answers = [];

  formData.getAll('question_ids[]').forEach(qid => {
    const answer = formData.get(`answer_${qid}`);
    answers.push({ question_id: qid, answer });
  });

  console.log("📨 Answers submitted:", answers);
  markAnswers({});
});

// ✅ 8. Mark Answers
function markAnswers() {
  document.querySelectorAll('.question-block').forEach(block => {
    const correct = block.getAttribute('data-correct');
    block.querySelectorAll('input[type="radio"]').forEach(radio => {
      if (radio.value === correct) {
        radio.parentElement.classList.add('bg-success', 'text-white', 'p-2', 'rounded');
      } else {
        radio.disabled = true;
      }
    });
  });
  console.log("🎯 Assessment marked.");
  
  // ✅ Show the Next Diorama button after assessment is done
  document.getElementById('nextDioramaBtn').classList.remove('d-none');
}


// ✅ 9. Helper Functions
function getDescriptionSource(data, language) {
  return language === 'tagalog'
    ? (age < 20 ? data.description_tagalog_minor : data.description_tagalog_adult)
    : (age < 20 ? data.description_english_minor : data.description_english_adult);
}

function getAudioSource(data, language) {
  return language === 'tagalog'
    ? (age < 20 ? data.tagalog_minor_audio : data.tagalog_adult_audio)
    : (age < 20 ? data.english_minor_audio : data.english_adult_audio);
}


function startNextDiorama() {
  Swal.fire({
    title: "Great job!",
    text: "You’ve completed this Diorama. Ready for the next one?",
    icon: "success",
    confirmButtonText: "OK"
  }).then(() => {
    console.log("➡️ Waiting for next scan...");
    document.getElementById('resultCard').style.display = 'none';
    document.getElementById('nextDioramaBtn').classList.add('d-none');
    document.getElementById('startScanBtn').style.display = 'block';
    // ❌ do NOT call startScanner() here
  });
}


</script>

</body>



</html>