<?php
include 'db_connect.php';

$diorama_id = $_GET['diorama_id'] ?? '';
$language = $_GET['language'] ?? 'english'; // default to english if not provided

if (!$diorama_id) {
    echo json_encode([]);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM assessment_questions WHERE diorama_id = ? AND language = ?");
$stmt->bind_param("is", $diorama_id, $language);
$stmt->execute();
$result = $stmt->get_result();

$questions = [];
while ($row = $result->fetch_assoc()) {
    $questions[] = $row;
}

echo json_encode($questions);
?>
