<?php
include('db_connect.php');

$id = $_GET['id'] ?? 0;

// Use prepared statement to avoid SQL injection
$stmt = $conn->prepare("SELECT * FROM diorama WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
echo json_encode([
    'id' => $row['id'],
    'name' => $row['name'],
    'description_tagalog_minor' => $row['description_tagalog_minor'],
    'description_tagalog_adult' => $row['description_tagalog_adult'],
    'description_english_minor' => $row['description_english_minor'],
    'description_english_adult' => $row['description_english_adult'],
    'image' => 'admins/' . $row['picture'], // ✅ renamed to "image"
    'tagalog_minor_audio' => 'admins/' . $row['tagalog_minor_audio'],
    'tagalog_adult_audio' => 'admins/' . $row['tagalog_adult_audio'],
    'english_minor_audio' => 'admins/' . $row['english_minor_audio'],
    'english_adult_audio' => 'admins/' . $row['english_adult_audio'],
]);


$stmt->close();
$conn->close();
