<!DOCTYPE html>
<html lang="en">

<head>
  <<head>
 <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<!-- Bootstrap CSS -->
<link rel="stylesheet" href="libs/bootstrap.min.css">

<!-- Font Awesome -->
<link rel="stylesheet" href="libs/all.min.css">

<!-- SweetAlert2 -->
<link rel="stylesheet" href="libs/sweetalert2.min.css">
<script src="libs/sweetalert2.min.js"></script>

<!-- Local Fonts -->
<link rel="stylesheet" href="fonts/poppins.css">


  <style>
    @font-face {
      font-family: 'Poppins';
      src: url('fonts/Poppins-Regular.woff2') format('woff2'),
           url('fonts/Poppins-Regular.woff') format('woff'),
           url('fonts/Poppins-Regular.ttf') format('truetype');
      font-weight: 400;
    }
    @font-face {
      font-family: 'Poppins';
      src: url('fonts/Poppins-SemiBold.woff2') format('woff2'),
           url('fonts/Poppins-SemiBold.woff') format('woff'),
           url('fonts/Poppins-SemiBold.ttf') format('truetype');
      font-weight: 600;
    }
    body {
      font-family: 'Poppins', sans-serif;
    }


    @media (max-width: 600px) {
      .swal2-popup {
        width: 90% !important;
        font-size: 1rem;
      }

      .swal2-input {
        font-size: 1rem;
        padding: 10px;
      }

      .swal2-title {
        font-size: 1.2rem;
      }
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
      font-family: Arial, sans-serif;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    th,
    td {
      padding: 12px 16px;
      text-align: left;
      border-bottom: 1px solid #e0e0e0;
    }

    thead {
      background-color: #f5f5f5;
    }

    th {
      font-weight: 600;
      color: #333;
    }

    tbody tr:nth-child(even) {
      background-color: #fafafa;
    }

    tbody tr:hover {
      background-color: #f1f1f1;
      cursor: default;
    }

    *,
    *::before,
    *::after {
      box-sizing: border-box;
      transition: all 0.25s ease;
    }

    :root {
      --primary-color: #4361ee;
      --secondary-color: #2dce89;
      --text-color: #2d3748;
      --light-text: #4a5568;
      --bg-color: #f8fafc;
      --card-bg: rgba(255, 255, 255, 0.85);
      --input-bg: rgba(255, 255, 255, 0.9);
      --shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }

    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(rgba(0, 0, 0, 0.3), rgba(0, 0, 0, 0.3)),
        url('exhibit1.jpg') no-repeat center center;
      background-size: cover;
      margin: 0;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--text-color);
      overflow-x: hidden;
    }

    .app-container {
      width: 100%;
      max-width: 480px;
      padding: 0 15px;
      margin: 0 auto;
      position: relative;
      z-index: 1;
    }

    .navbar {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      background: rgba(6, 23, 46, 0.95);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      padding: 15px 20px;
      z-index: 1000;
      box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
    }

    .navbar-brand {
      display: flex;
      align-items: center;
      font-weight: 700;
      color: #6ec1e4;
      font-size: 1.6rem;
      letter-spacing: 0.5px;
    }

    .brand-icon {
      margin-right: 10px;
      background: #6ec1e4;
      color: #06172e;
      width: 36px;
      height: 36px;
      border-radius: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.2rem;
    }

    .form-container {
      background: var(--card-bg);
      border-radius: 24px;
      padding: 35px 30px;
      width: 100%;
      box-shadow: var(--shadow);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      border: 1px solid rgba(255, 255, 255, 0.3);
      color: var(--text-color);
      overflow: hidden;
      transform: translateY(0);
      animation: slideUp 0.6s ease-out;
    }

    @keyframes slideUp {
      0% {
        opacity: 0;
        transform: translateY(60px);
      }

      100% {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .form-title {
      font-weight: 700;
      text-align: center;
      font-size: 28px;
      margin-bottom: 10px;
      color: var(--text-color);
    }

    .form-subtitle {
      text-align: center;
      color: var(--light-text);
      font-size: 0.9rem;
      margin-bottom: 30px;
    }

    .form-group {
      margin-bottom: 25px;
      position: relative;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: var(--text-color);
      transition: all 0.3s;
      font-size: 0.95rem;
    }

    .form-control {
      background-color: var(--input-bg);
      border: 2px solid rgba(226, 232, 240, 0.8);
      border-radius: 16px;
      padding: 15px;
      color: var(--text-color);
      font-size: 0.95rem;
      width: 100%;
      transition: all 0.3s ease;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.03);
    }

    .form-control::placeholder {
      color: #a0aec0;
    }

    .form-control:focus {
      background-color: white;
      color: var(--text-color);
      border-color: var(--primary-color);
      box-shadow: 0 0 0 4px rgba(67, 97, 238, 0.1);
      outline: none;
    }

    .form-control-icon {
      position: absolute;
      right: 15px;
      top: 49px;
      color: #a0aec0;
      pointer-events: none;
    }

    .form-group:focus-within .form-control-icon {
      color: var(--primary-color);
    }

    .input-container {
      position: relative;
    }

    .btn-submit {
      width: 100%;
      border-radius: 50px;
      padding: 15px;
      font-weight: 600;
      font-size: 1rem;
      background-color: var(--primary-color);
      border: none;
      color: white;
      box-shadow: 0 10px 20px rgba(67, 97, 238, 0.2);
      position: relative;
      overflow: hidden;
      transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      margin-top: 10px;
      letter-spacing: 0.5px;
    }

    .btn-submit:hover {
      transform: translateY(-3px);
      box-shadow: 0 15px 30px rgba(67, 97, 238, 0.3);
      background-color: #3a56d4;
    }

    .btn-submit:active {
      transform: translateY(0);
    }

    .btn-submit::after {
      content: '';
      position: absolute;
      top: 50%;
      left: 50%;
      width: 5px;
      height: 5px;
      background: rgba(255, 255, 255, 0.3);
      opacity: 0;
      border-radius: 100%;
      transform: scale(1, 1) translate(-50%);
      transform-origin: 50% 50%;
    }

    .btn-submit:hover::after {
      animation: ripple 1s ease-out;
    }

    @keyframes ripple {
      0% {
        transform: scale(0, 0);
        opacity: 0.3;
      }

      100% {
        transform: scale(40, 40);
        opacity: 0;
      }
    }

    .select-container {
      position: relative;
    }

    .select-container::after {
      content: '\f107';
      font-family: 'Font Awesome 6 Free';
      font-weight: 900;
      color: #a0aec0;
      position: absolute;
      right: 15px;
      top: calc(50% + 8px);
      pointer-events: none;
    }

    .select-container:focus-within::after {
      color: var(--primary-color);
    }

    /* Progress Bar */
    .progress-container {
      width: 100%;
      margin-bottom: 25px;
      padding-top: 5px;
    }

    .progress-steps {
      display: flex;
      justify-content: space-between;
      margin-bottom: 10px;
    }

    .step-indicator {
      width: 25%;
      text-align: center;
      position: relative;
    }

    .step-dot {
      width: 20px;
      height: 20px;
      background-color: #e2e8f0;
      border-radius: 50%;
      margin: 0 auto 8px;
      position: relative;
      z-index: 2;
      transition: all 0.3s ease;
    }

    .active .step-dot {
      background-color: var(--primary-color);
      transform: scale(1.2);
      box-shadow: 0 0 0 4px rgba(67, 97, 238, 0.2);
    }

    .completed .step-dot {
      background-color: var(--secondary-color);
    }

    .step-label {
      font-size: 0.7rem;
      color: #a0aec0;
      font-weight: 500;
    }

    .active .step-label {
      color: var(--primary-color);
      font-weight: 600;
    }

    .completed .step-label {
      color: var(--secondary-color);
    }

    .progress-line {
      position: absolute;
      top: 10px;
      left: 0;
      right: 0;
      height: 2px;
      background-color: #e2e8f0;
      z-index: 1;
    }

    .progress-line-fill {
      position: absolute;
      top: 0;
      left: 0;
      height: 100%;
      background-color: var(--secondary-color);
      transition: width 0.6s ease;
    }

    /* Card Animation */
    @keyframes cardEntrance {
      from {
        opacity: 0;
        transform: scale(0.95);
      }

      to {
        opacity: 1;
        transform: scale(1);
      }
    }

    .form-container {
      animation: cardEntrance 0.6s ease-out;
    }

    .bottom-text {
      text-align: center;
      margin-top: 20px;
      color: white;
      font-size: 0.9rem;
      text-shadow: 0 1px 3px rgba(0, 0, 0, 0.4);
    }

    .bottom-text a {
      color: #6ec1e4;
      text-decoration: none;
      font-weight: 600;
    }

    .bottom-text a:hover {
      text-decoration: underline;
    }

    /* Input animations */
    .form-control:focus+.form-control-icon {
      transform: translateY(-5px);
    }

    /* Loader */
    .loader {
      display: none;
      width: 24px;
      height: 24px;
      border: 3px solid white;
      border-bottom-color: transparent;
      border-radius: 50%;
      position: absolute;
      top: 50%;
      left: 50%;
      margin-top: -12px;
      margin-left: -12px;
      animation: rotate 1s linear infinite;
    }

    @keyframes rotate {
      from {
        transform: rotate(0deg);
      }

      to {
        transform: rotate(360deg);
      }
    }

    .btn-submit.loading {
      color: transparent;
    }

    .btn-submit.loading .loader {
      display: block;
    }

    /* Additional animations */
    .form-group.animate {
      animation: fadeInUp 0.5s both;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(20px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Group members section styling */
    .group-section {
      background: rgba(255, 255, 255, 0.7);
      border-radius: 16px;
      padding: 20px;
      margin-top: 20px;
      margin-bottom: 20px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .section-title {
      font-weight: 600;
      margin-bottom: 15px;
      color: var(--text-color);
      border-bottom: 2px solid var(--primary-color);
      padding-bottom: 8px;
      display: inline-block;
    }

    .members-list {
      max-height: 200px;
      overflow-y: auto;
      margin-top: 10px;
    }

    .member-item {
      display: flex;
      align-items: center;
      padding: 8px 0;
      border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }

    .member-item:last-child {
      border-bottom: none;
    }

    .member-number {
      font-weight: 600;
      color: var(--primary-color);
      width: 30px;
    }

    .member-name {
      flex-grow: 1;
    }

    /* Mobile-specific adjustments */
    @media (max-width: 480px) {
      .form-container {
        padding: 25px 20px;
        margin-top: 60px;
      }

      .navbar {
        padding: 10px 15px;
      }

      .form-title {
        font-size: 24px;
      }
    }
  </style>
</head>
<body>
  <nav class="navbar">
    <div class="navbar-brand">
      <span class="brand-icon"><i class="fas fa-map-marked-alt"></i></span>
      iStorya
    </div>
    <div>
      <span id="modeIndicator"></span>
    </div>
  </nav>

  <div class="app-container">
    <div class="form-container">
      <h3 class="form-title">Welcome to iStorya</h3>
      <p class="form-subtitle">Please fill in your details to begin your journey</p>

      <!-- Progress Steps -->
      <div class="progress-container">
        <div class="progress-steps">
          <div class="step-indicator active">
            <div class="step-dot"></div>
            <div class="step-label">Tour Type</div>
          </div>
          <div class="step-indicator" id="stepName">
            <div class="step-dot"></div>
            <div class="step-label">Name</div>
          </div>
          <div class="step-indicator" id="stepAge">
            <div class="step-dot"></div>
            <div class="step-label">Age</div>
          </div>
          <div class="step-indicator" id="stepGender">
            <div class="step-dot"></div>
            <div class="step-label">Gender</div>
          </div>
        </div>
        <div class="progress-line">
          <div class="progress-line-fill" style="width: 25%"></div>
        </div>
      </div>

      <form id="localForm">
        <div class="form-group">
          <label>Tour Type:</label>
          <div class="select-container">
            <select id="tour" class="form-control" required>
              <option value="" disabled selected>Select Tour Type</option>
              <option value="Solo">Solo</option>
              <option value="Group">Group</option>
            </select>
          </div>
        </div>

        <div class="form-group" id="nameGroup">
          <label id="nameLabel">Name:</label>
          <div class="input-container">
            <input required type="text" id="name" class="form-control" placeholder="Enter your name">
            <i class="fas fa-user form-control-icon" style="margin-top: -25px"></i>
          </div>
        </div>

        <div class="form-group" id="ageGroup">
          <label>Age:</label>
          <div class="input-container">
            <input required type="number" id="age" class="form-control" placeholder="Enter your age" min="1">
            <i class="fas fa-birthday-cake form-control-icon" style="margin-top: -20px"></i>
          </div>
        </div>

        <div class="form-group" id="genderGroup">
          <label>Gender:</label>
          <div class="select-container">
            <select id="gender" class="form-control" required>
              <option value="" disabled selected>Select your gender</option>
              <option value="Male">Male</option>
              <option value="Female">Female</option>
              <option value="Prefer not to say">Prefer not to say</option>
            </select>
          </div>
        </div>

        <!-- Group Members Section -->
        <div id="groupMembersSection" class="group-section" style="display: none;">
          <h4 class="section-title">Group Members</h4>
          <p class="text-muted">Add your group members below</p>
          <div style="margin-top: 15px;">
            <button type="button" class="btn btn-success" onclick="addParticipant()">
              <i class="fas fa-user-plus me-2"></i>Add Member
            </button>
          </div>
          <div class="members-list" id="membersList"></div>
        </div>

        <button type="submit" class="btn btn-submit" id="submitBtn">
          <span>Begin Experience</span>
          <span class="loader"></span>
        </button>
      </form>
    </div>

    <div class="bottom-text">
      Already know iStorya? <a href="diorama.php">Skip tour</a>
    </div>
  </div>
<!-- Local Dexie.js -->
<script src="libs/dexie.min.js"></script>
<script src="libs/sweetalert2.min.js"></script>
<script src="libs/bootstrap.bundle.min.js"></script>

<script>
  // === Mode indicator ===
  let mode = localStorage.getItem("iStoryaMode") || "online"; // same key as index.php
  const modeIndicator = document.getElementById("modeIndicator");
  modeIndicator.textContent = mode === "offline" ? "(Offline Mode)" : "(Online Mode)";
  modeIndicator.style.color = mode === "offline" ? "#00ff99" : "#aad3e6";

  // === IndexedDB setup ===
  const db = new Dexie("iStoryaDB");
  db.version(1).stores({
    users: "++id" // only auto-increment, no forced keys
  });

  // === Form step logic ===
  const nameGroup = document.getElementById('nameGroup');
  const ageGroup = document.getElementById('ageGroup');
  const genderGroup = document.getElementById('genderGroup');
  const groupMembersSection = document.getElementById('groupMembersSection');
  const progressFill = document.querySelector('.progress-line-fill');

  nameGroup.style.display = 'none';
  ageGroup.style.display = 'none';
  genderGroup.style.display = 'none';

  document.getElementById('tour').addEventListener('change', function() {
    const tourType = this.value;
    document.getElementById('nameLabel').textContent = tourType === 'Group' ? 'Leader Name:' : 'Name:';
    groupMembersSection.style.display = tourType === 'Group' ? 'block' : 'none';
    if (tourType === 'Group') {
      localStorage.removeItem('participants');
      updateMembersList();
    }
    nameGroup.style.display = 'block';
    document.getElementById('name').focus();
    document.getElementById('stepName').classList.add('active');
    progressFill.style.width = '50%';
  });

  document.getElementById('name').addEventListener('input', function() {
    if (this.value.length > 2) {
      ageGroup.style.display = 'block';
      document.getElementById('stepAge').classList.add('active');
      progressFill.style.width = '75%';
    }
  });

  document.getElementById('age').addEventListener('input', function() {
    if (this.value > 0) {
      genderGroup.style.display = 'block';
      document.getElementById('stepGender').classList.add('active');
      progressFill.style.width = '100%';
    }
  });

  // === Form submit ===
 document.getElementById('localForm').addEventListener('submit', async function(e) {
  e.preventDefault();
  const submitBtn = document.getElementById('submitBtn');
  submitBtn.classList.add('loading');
  document.querySelectorAll('.step-indicator').forEach(step => step.classList.add('completed'));

  const name = document.getElementById('name').value;
  const tour = document.getElementById('tour').value;
  const age = document.getElementById('age').value;
  const gender = document.getElementById('gender').value;
  const participants = JSON.parse(localStorage.getItem('participants') || '[]');

  // Save to localStorage for quick retrieval
  localStorage.setItem('user_name', name);
  localStorage.setItem('user_tour', tour);
  localStorage.setItem('user_age', age);
  localStorage.setItem('user_gender', gender);

  if (mode === "online") {
    try {
      await fetch("api/save_user.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ name, tour, age, gender, participants })
      });
    } catch (e) {
      console.warn("⚠️ Could not save to API, data only saved in localStorage.");
    }
  } else {
    console.log("⚠️ Offline mode: not saving to IndexedDB, only localStorage.");
  }

  setTimeout(() => {
    window.location.href = 'diorama.php';
  }, 800);
});


  // === Group member helpers ===
  function updateMembersList() {
    const participants = JSON.parse(localStorage.getItem('participants') || '[]');
    const membersList = document.getElementById('membersList');
    membersList.innerHTML = '';
    if (!participants.length) {
      membersList.innerHTML = '<p class="text-muted">No members added yet</p>';
      return;
    }
    participants.forEach((participant, index) => {
      const memberItem = document.createElement('div');
      memberItem.className = 'member-item';
      memberItem.innerHTML = `
        <div class="member-number">${index + 1}.</div>
        <div class="member-name">${participant.name}</div>
        <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeParticipant(${index})">
          <i class="fas fa-times"></i>
        </button>`;
      membersList.appendChild(memberItem);
    });
  }

  function addParticipant() {
    Swal.fire({
      title: 'Add Group Member',
      html: `<input type="text" id="name" class="swal2-input" placeholder="Member Name">`,
      confirmButtonText: 'Add Member',
      preConfirm: () => {
        const name = Swal.getPopup().querySelector('#name').value;
        if (!name) Swal.showValidationMessage(`Please enter the member name`);
        return { name };
      }
    }).then((result) => {
      if (result.isConfirmed) {
        const participants = JSON.parse(localStorage.getItem('participants') || '[]');
        participants.push(result.value);
        localStorage.setItem('participants', JSON.stringify(participants));
        updateMembersList();
        Swal.fire({ position: 'top-end', icon: 'success', title: 'Member added', showConfirmButton: false, timer: 1500 });
      }
    });
  }

  function removeParticipant(index) {
    const participants = JSON.parse(localStorage.getItem('participants') || '[]');
    Swal.fire({
      title: 'Remove Member',
      text: `Remove ${participants[index].name} from the group?`,
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Yes, remove'
    }).then((result) => {
      if (result.isConfirmed) {
        participants.splice(index, 1);
        localStorage.setItem('participants', JSON.stringify(participants));
        updateMembersList();
        Swal.fire({ position: 'top-end', icon: 'success', title: 'Member removed', showConfirmButton: false, timer: 1500 });
      }
    });
  }

  document.addEventListener('DOMContentLoaded', updateMembersList);
</script>
</body>


</body>

</html>