const CACHE_NAME = "istorya-cache-v5";

const ASSETS = [
  "/index.php",
"/setup.php",
"/diorama.php",
"/get_diorama.php",
"/get_assessment_questions.php",
"/save_assessment_answers.php",

"/libs/dexie.min.js",
"/libs/bootstrap.bundle.min.js",
"/libs/sweetalert2.min.js",
"/libs/sweetalert2.all.min.js",
"/libs/html5-qrcode.min.js",
"/assets/style.css",
"/assets/main.js",

"/logo.png",
"/logo.jpg",
"/logos.png",
"/exhibit1.jpg",
"/exhibit2.jpg",
"/exhibit3.png",
"/admins/uploads/charles.jpg",
"/admins/uploads/download (6).png",
"/admins/uploads/1646.png",

"/fonts/Poppins-SemiBold.ttf",
"/fonts/Poppins-Regular.ttf",

"/admins/uploads/audio/correctans.mp3",
"/admins/uploads/audio/12.public_english_M.mp3",
"/admins/uploads/audio/rectangle.mp3",
"/admins/uploads/audio/4. Poblacion.mp3",
"/admins/uploads/audio/7. Estacion_english.mp3",
"/admins/uploads/audio/bolo tagalog.mp3",
"/admins/uploads/audio/14. Monasterio_Filipino_M.mp3",
"/admins/uploads/audio/14. monasterio_english_M.mp3",
"/admins/uploads/audio/10. Casa-Real_english_A.mp3",
"/admins/uploads/audio/Ang Noli Me Tangere .mp3",
"/admins/uploads/audio/countdown.mp3",


];


// Install - cache only important assets
self.addEventListener("install", event => {
  event.waitUntil(
    caches.open(CACHE_NAME).then(async cache => {
      console.log(`📦 Caching ${ASSETS.length} essential assets...`);
      for (const asset of ASSETS) {
        try {
          const response = await fetch(asset, { cache: "no-cache" });
          if (!response.ok) throw new Error(`HTTP ${response.status}`);
          await cache.put(asset, response.clone());
          console.log(`✅ Cached: ${asset}`);
        } catch (err) {
          console.warn(`⚠️ Skipped: ${asset}`, err);
        }
      }
    })
  );
  self.skipWaiting();
});

// Activate - clear old caches
self.addEventListener("activate", event => {
  event.waitUntil(
    caches.keys().then(keys =>
      Promise.all(keys.filter(k => k !== CACHE_NAME).map(k => caches.delete(k)))
    )
  );
  console.log("♻️ Service Worker: Activated");
  return self.clients.claim();
});

// Fetch - cache-first with network fallback
self.addEventListener("fetch", event => {
  event.respondWith(
    caches.match(event.request).then(cached => {
      if (cached) return cached;
      return fetch(event.request)
        .then(networkResponse => {
          return caches.open(CACHE_NAME).then(cache => {
            cache.put(event.request, networkResponse.clone());
            return networkResponse;
          });
        })
        .catch(() => {
          console.warn("⚠️ Offline and no cache for", event.request.url);
        });
    })
  );
});
